*************************************
*** This do-file creates figure 2 ***
*************************************

clear
set mem 1100m

* !!! PLEASE SPECIFY !!! the directory where the file nj_sampleframe.dta is stored:
local njdir=""

* !!! PLEASE SPECIFY !!!
* htype="wkpd": by weeks of UI paid
* for figure 2, type the following:
local htype="wkpd"
local htype3="weeks of UI paid"
local htype4=0.08

* choose range of duration to be shown
local durmax= 98
local durmin= 1

* chose number of weeks of duration for which hazard is computed
local lendur=102
local lendurp1=`lendur'+1

* choose date beyond which spells count as censored (Last week of april=2617)
local cens=2616

* chose date of extraction of data that was used for sampling
local cenm=2584

* load universe file
use `njdir'nj_universe.dta, clear
sort id
save `njdir'nj_universe.dta, replace

* load sample frame file and merge on baseweeks from universe file
use `njdir'nj_sampleframe.dta, clear
sort id
merge id using `njdir'nj_universe.dta, _merge(merge_baseweeks) keep(baseweeks) nokeep

* week of claim and date of last payment
gen claimweek = wofd(dateclaim)
gen lpw = string(last_payment_week)
gen lpy = round((last_payment_week/10000))
gen lpm = round((last_payment_week-lpy*10000)/100)
gen lpd = last_payment_week - lpy*10000 - lpm*100
gen lpdate = mdy(lpm, lpd, lpy)
gen lpweek = wofd(lpdate)
format lpdate %td
format lpweek %tw

drop if lpdate==.
*replace recall = 1 if datereturn!=.
*drop if recall==1

* in sample of respondents
gen respondent = 0
replace respondent = 1 if consent==1


****************************************************
*** Definition of potential duration of benefits ***
****************************************************

* not qualified for regular benefits
gen     notqualr = 0
replace notqualr = 1 if baseweeks < 20 & baseearn < 7300
replace notqualr = 0 if weekspaid_all_end>0

* not qualified for extended benefits
gen     notquale = 0
replace notquale = 1 if baseweeks < 20 & baseearn < 40*benerate
replace notquale = 1 if notqualr==1
replace notquale = 0 if lastpgm>0
replace notquale = 0 if tier1wk_end > 26
replace notquale = 0 if tier2wk_end > 0
replace notquale = 0 if tier3wk_end > 0
replace notquale = 0 if tier4wk_end > 0
replace notquale = 0 if eb_weeks_end> 0

* potential duration of regular benefits and extended benefits (each tier)
* old: before extension to 99 weeks / new: after extnesion to 99 weeks
gen     baseweeks2=maxbene/benerate
replace baseweeks2=0 if benerate==0

gen potdur_reg      = min(26, baseweeks2)
gen potdur_tier1old = min(26, baseweeks2) + min(20, 0.8*baseweeks2)
gen potdur_tier2old = min(26, baseweeks2) + min(20, 0.8*baseweeks2) + min(13, 0.5*baseweeks2)
gen potdur_extold   = min(26, baseweeks2) + min(20, 0.8*baseweeks2) + min(13, 0.5*baseweeks2) + min(20, 0.8*baseweeks2)

gen potdur_tier1new = min(26, baseweeks2) + min(20, 0.8*baseweeks2)
gen potdur_tier2new = min(26, baseweeks2) + min(20, 0.8*baseweeks2) + min(14, 0.54*baseweeks2)
gen potdur_tier3new = min(26, baseweeks2) + min(20, 0.8*baseweeks2) + min(14, 0.54*baseweeks2) + min(13, 0.5*baseweeks2) 
gen potdur_tier4new = min(26, baseweeks2) + min(20, 0.8*baseweeks2) + min(14, 0.54*baseweeks2) + min(13, 0.5*baseweeks2) + min(6, 0.24*baseweeks2)
gen potdur_extnew   = min(26, baseweeks2) + min(20, 0.8*baseweeks2) + min(14, 0.54*baseweeks2) + min(13, 0.5*baseweeks2) + min(6, 0.24*baseweeks2) + min(20, 0.8*baseweeks2) if notquale==0

replace potdur_tier1old = potdur_reg if notquale == 1
replace potdur_tier2old = potdur_reg if notquale == 1
replace potdur_tier1new = potdur_reg if notquale == 1
replace potdur_tier2new = potdur_reg if notquale == 1
replace potdur_tier3new = potdur_reg if notquale == 1
replace potdur_tier4new = potdur_reg if notquale == 1
replace potdur_extold   = potdur_reg if notquale == 1
replace potdur_extnew   = potdur_reg if notquale == 1


**********************
*** strata weights ***
**********************

* cohort by email
gen     cohemail = 1 if weekspaid_all >= 0  & weekspaid_all <= 9   & emaddr=="N"
replace cohemail = 2 if weekspaid_all >= 10 & weekspaid_all <= 19  & emaddr=="N"
replace cohemail = 3 if weekspaid_all >= 20 & weekspaid_all <= 29  & emaddr=="N"
replace cohemail = 4 if weekspaid_all >= 30 & weekspaid_all <= 39  & emaddr=="N"
replace cohemail = 5 if weekspaid_all >= 40 & weekspaid_all <= 49  & emaddr=="N"
replace cohemail = 6 if weekspaid_all >= 50 & weekspaid_all <= 59  & emaddr=="N"
replace cohemail = 7 if weekspaid_all >= 60 & weekspaid_all <= 69  & emaddr=="N"
replace cohemail = 8 if weekspaid_all >= 70 & emaddr=="N"
replace cohemail = 9 if weekspaid_all >= 0  & weekspaid_all <= 9   & emaddr=="Y"
replace cohemail = 10 if weekspaid_all >= 10 & weekspaid_all <= 19  & emaddr=="Y"
replace cohemail = 11 if weekspaid_all >= 20 & weekspaid_all <= 29  & emaddr=="Y"
replace cohemail = 12 if weekspaid_all >= 30 & weekspaid_all <= 39  & emaddr=="Y"
replace cohemail = 13 if weekspaid_all >= 40 & weekspaid_all <= 49  & emaddr=="Y"
replace cohemail = 14 if weekspaid_all >= 50 & weekspaid_all <= 59  & emaddr=="Y"
replace cohemail = 15 if weekspaid_all >= 60 & weekspaid_all <= 69  & emaddr=="Y"
replace cohemail = 16 if weekspaid_all >= 70 & emaddr=="Y"

* compute strata weights
gen     chrtwgt = 28420/2000 if weekspaid_all >= 0  & weekspaid_all <= 9   & emaddr=="N"
replace chrtwgt = 36094/2000 if weekspaid_all >= 10 & weekspaid_all <= 19  & emaddr=="N"
replace chrtwgt = 29289/2000 if weekspaid_all >= 20 & weekspaid_all <= 29  & emaddr=="N"
replace chrtwgt = 27525/2000 if weekspaid_all >= 30 & weekspaid_all <= 39  & emaddr=="N"
replace chrtwgt = 21165/2000 if weekspaid_all >= 40 & weekspaid_all <= 49  & emaddr=="N"
replace chrtwgt = 16725/2000 if weekspaid_all >= 50 & weekspaid_all <= 59  & emaddr=="N"
replace chrtwgt = 12201/2000 if weekspaid_all >= 60 & weekspaid_all <= 69  & emaddr=="N"
replace chrtwgt = 14240/4000 if weekspaid_all >= 70 & emaddr=="N"
replace chrtwgt = 32788/5000 if weekspaid_all >= 0  & weekspaid_all <= 9   & emaddr=="Y"
replace chrtwgt = 35283/5000 if weekspaid_all >= 10 & weekspaid_all <= 19  & emaddr=="Y"
replace chrtwgt = 31493/5000 if weekspaid_all >= 20 & weekspaid_all <= 29  & emaddr=="Y"
replace chrtwgt = 29628/5000 if weekspaid_all >= 30 & weekspaid_all <= 39  & emaddr=="Y"
replace chrtwgt = 19296/5000 if weekspaid_all >= 40 & weekspaid_all <= 49  & emaddr=="Y"
replace chrtwgt = 12332/5000 if weekspaid_all >= 50 & weekspaid_all <= 59  & emaddr=="Y"
replace chrtwgt = 7528 /7528 if weekspaid_all >= 60 & weekspaid_all <= 69  & emaddr=="Y"
replace chrtwgt = 8285 /8285 if weekspaid_all >= 70 & emaddr=="Y"


**********************************************************************
*** week of UI exit hazard + censoring (Last week of april (2617)) ***
*** 1. udur_x: denotes the duration at the end of the study        ***
*** 2. cens_x: denotes whether the spell was censored              ***
*** 3. cenm_x: denotes whether the duration at the beginnig of the ***
***            of the study and thus excluded from the number of   ***
***            ongoing spells                                      ***
*** 4. uiha_x: denotes the week of UI exit if not censored         ***
***                                                                ***
*** where x stands for the way duration is measured                ***
**********************************************************************

* x: duration measured as weeks of UI paid
gen udur_wkpd = weekspaid_all_end
gen cens_wkpd = weekspaid_all_end  if lpweek >= `cens' | date_new_claim!=.
gen cenm_wkpd = weekspaid_all
gen uiha_wkpd = weekspaid_all_end  if lpweek <  `cens' & date_new_claim==.


keep weekspaid_all* cens_* cenm_* uiha_* chrtwgt udur_* *wgt respondent


*************************************************
*** expand data set by individual by duration ***
*************************************************

gen id = _n
expand `lendurp1'

sort id
by id: gen dur = _n-1

if "`htype'"=="left" {
replace dur = 99-dur
}

*** generate exit and censoring by duration (unweighted and weighted) ***
gen nexit_`htype'_nowgt=0
gen ncens_`htype'_nowgt=0
gen ncenm_`htype'_nowgt=0
gen nexit_`htype'_chrtwgt=0
gen ncens_`htype'_chrtwgt=0
gen ncenm_`htype'_chrtwgt=0
gen nexit_`htype'_perswgt=0
gen ncens_`htype'_perswgt=0
gen ncenm_`htype'_perswgt=0

forvalues x=0(1)`lendur' {

* weeks of unemployment duration
* unweighted
replace nexit_`htype'_nowgt=1 if uiha_`htype'==`x' & dur==`x'
replace ncens_`htype'_nowgt=1 if cens_`htype'==`x' & dur==`x'
replace ncenm_`htype'_nowgt=1 if cenm_`htype'==`x' & dur==`x'

* weighted with strata weights
replace nexit_`htype'_chrtwgt=chrtwgt if uiha_`htype'==`x' & dur==`x'
replace ncens_`htype'_chrtwgt=chrtwgt if cens_`htype'==`x' & dur==`x'
replace ncenm_`htype'_chrtwgt=chrtwgt if cenm_`htype'==`x' & dur==`x'

* weighted with person weights
replace nexit_`htype'_perswgt=perswgt if uiha_`htype'==`x' & dur==`x'
replace ncens_`htype'_perswgt=perswgt if cens_`htype'==`x' & dur==`x'
replace ncenm_`htype'_perswgt=perswgt if cenm_`htype'==`x' & dur==`x'

}


*********************************************
*** count exits and censoring by duration ***
*********************************************

collapse (sum) nexit* ncens* ncenm*, by(dur respondent)

reshape wide nexit* ncens* ncenm*, i(dur) j(respondent)


*************************
*** construct hazards ***
*************************

local weight_type "nowgt chrtwgt perswgt"

foreach wtype of local weight_type {

gen nexit_`htype'_`wtype'2 = nexit_`htype'_`wtype'0 + nexit_`htype'_`wtype'1
gen ncenm_`htype'_`wtype'2 = ncenm_`htype'_`wtype'0 + ncenm_`htype'_`wtype'1
gen ncens_`htype'_`wtype'2 = ncens_`htype'_`wtype'0 + ncens_`htype'_`wtype'1

forvalues xs=0(1)2 {


* hazard by duration
sort dur
gen surv_`htype'_`wtype'`xs' = ncenm_`htype'_`wtype'`xs' - ncens_`htype'_`wtype'`xs'  if dur==0
gen survf_`htype'_`wtype'`xs' = 1  if dur==0
gen kmhaz_`htype'_`wtype'`xs' = 0
gen sd_`htype'_`wtype'`xs' = 0
*replace kmhaz_`htype'_`wtype'`xs' = nexit_`htype'_`wtype'`xs'/surv_`htype'_`wtype'`xs' if dur==0 & nexit_`htype'_`wtype'`xs'>0 & nexit_`htype'_`wtype'`xs'!=.

forvalues x=2(1)`lendurp1' {
replace surv_`htype'_`wtype'`xs' = surv_`htype'_`wtype'`xs'[`x'-1] - nexit_`htype'_`wtype'`xs'[`x'-1] - ncens_`htype'_`wtype'`xs'[`x'] + ncenm_`htype'_`wtype'`xs'[`x'] if dur==`x'-1
replace kmhaz_`htype'_`wtype'`xs' = nexit_`htype'_`wtype'`xs'[`x']/surv_`htype'_`wtype'`xs'[`x'] if dur==`x'-1
replace sd_`htype'_`wtype'`xs' = sqrt(kmhaz_`htype'_`wtype'`xs'[`x']*(1-kmhaz_`htype'_`wtype'`xs'[`x'])/surv_`htype'_nowgt`xs'[`x'])  if dur==`x'-1
replace survf_`htype'_`wtype'`xs' = survf_`htype'_`wtype'`xs'[`x'-1]*(1-kmhaz_`htype'_`wtype'`xs'[`x'-1]) if dur==`x'-1
}
gen failf_`htype'_`wtype'`xs' = 1-survf_`htype'_`wtype'`xs'


*** 95% confidence band ***
gen kmp_`htype'_`wtype'`xs' = kmhaz_`htype'_`wtype'`xs' + 1.96*sd_`htype'_`wtype'`xs'
gen kmm_`htype'_`wtype'`xs' = kmhaz_`htype'_`wtype'`xs' - 1.96*sd_`htype'_`wtype'`xs'
}

label variable kmhaz_`htype'_`wtype'2 "Hazard - sample frame"
label variable kmhaz_`htype'_`wtype'1 "Hazard - respondents"
label variable kmhaz_`htype'_`wtype'0 "Hazard - non-respondents"
label variable kmp_`htype'_`wtype'1   "95% confidence band"
label variable kmm_`htype'_`wtype'1   "95% confidence band"
label variable survf_`htype'_`wtype'2 "Sample frame"
label variable survf_`htype'_`wtype'1 "Respondents"
label variable survf_`htype'_`wtype'0 "Non-respondents"
label variable failf_`htype'_`wtype'2 "Sample frame"
label variable failf_`htype'_`wtype'1 "Respondents"
label variable failf_`htype'_`wtype'0 "Non-respondents"
}


*********************************************************
*** Kaplan-Meier hazard plot by unemployment duration ***
*********************************************************

tsset dur
*local htype="wkpd"
*local htype3="weeks of UI paid"
*local htype4=0.08
*local htype3="weeks since UI claim"
*local htype4=0.15
*local durmax=98
*local durmin=1

graph twoway tsline kmhaz_`htype'_nowgt1 kmp_`htype'_nowgt1 kmm_`htype'_nowgt1 kmhaz_`htype'_nowgt2 if dur <=`durmax' & dur >= `durmin', ///
yscale(range(0(0.01)0.05)) xline(99, lcolor(black) lpattern(dash) lwidth(thin)) xlabel(1 13 26 39 52 65 78 91 99) xscale(range(1 99)) ///
lwidth(medthick thin thin medthick) lcolor(black gs10 gs10 black) lpattern(solid solid solid ..-) ///
xtitle("Unemployment duration (`htype3')", color(black)) ytitle("Hazard", color(black)) ///
title("Kaplan-Meier UI exit hazard by unempl. duration (unweighted)", color(black) size(medium)) ///
ttext(`htype4' 99 "Maximum UI benefit duration", place(se) orient(vertical) size(vsmall)) ///
graphregion(color(white)) ///
legend(order(1 2 4) region(lcolor(white))) ///
note("Notes: The estimated hazards are unweighted. The confidence bands for the sample frame are not shown because" ///
"the standard errors are usually small (around 0.001, but higher for less than 20 weeks of unemployment duration)." ///
" ", size(vsmall))
graph export `njdir'kmhaz_`htype'_nowgt_durmin`durmin'_durmax`durmax'.png, replace hei(1200) wid(1650) 


*** this is table 2 ***

graph twoway tsline kmhaz_`htype'_perswgt1 kmp_`htype'_perswgt1 kmm_`htype'_perswgt1 kmhaz_`htype'_chrtwgt2 if dur <=`durmax' & dur >= `durmin', ///
yscale(range(0(0.01)0.05)) xline(99, lcolor(black) lpattern(dash) lwidth(thin)) xlabel(1 13 26 39 52 65 78 91 99) xscale(range(1 99)) ///
lwidth(medthick thin thin medthick) lcolor(black gs10 gs10 black) lpattern(solid solid solid ..-) ///
xtitle("Unemployment duration (`htype3')", color(black)) ytitle("Hazard", color(black)) ///
title("Kaplan-Meier UI exit hazard by unemployment duration (weighted)", color(black) size(medium)) ///
ttext(`htype4' 99 "Maximum UI benefit duration", place(se) orient(vertical) size(vsmall)) ///
graphregion(color(white)) ///
legend(order(1 2 4) region(lcolor(white))) ///
note("Notes: For respondents the hazards are weighted with survey weights and for the sample frame with strata weights." ///
"The confidence bands for the sample frame are not shown because the standard errors are usually small (around 0.001," ///
"but higher for less than 20 weeks of unemployment duration).", size(vsmall))
graph export `njdir'kmhaz_`htype'_perswgt_durmin`durmin'_durmax`durmax'.png, replace hei(1200) wid(1650) 
graph export `njdir'kmhaz_`htype'_perswgt_durmin`durmin'_durmax`durmax'.eps, replace



